<?php $title='Rapor Nilai'; ?>
<h1>Rapor Nilai</h1>

<?php if(!$subject || !$term): ?>
  <div class="alert alert-error">Mapel atau Term belum tersedia. Mohon hubungi admin.</div>
<?php else: ?>
  <div class="report-card">
    <h2>Hi, <?= htmlspecialchars($u['full_name']) ?> 👋</h2>
    <p>Kamu berhasil menyelesaikan UTS <?= htmlspecialchars($subject['name']) ?> — <?= htmlspecialchars($term['name']) ?></p>
    <div class="score"><?= $total_nilai!==null ? number_format($total_nilai,2) : '0.00' ?></div>
  </div>

  <div class="card">
    <h3>Rincian Penilaian</h3>
    <table>
      <thead>
        <tr>
          <th>Komponen</th><th>Bobot</th><th>Nilai</th><th>Skor Akhir</th>
        </tr>
      </thead>
      <tbody>
        <tr>
          <td>Teori</td>
          <td>30%</td>
          <td><?= number_format($theori,2) ?></td>
          <td><?= number_format($theori * 0.30, 2) ?></td>
        </tr>
        <tr>
          <td>Praktik (Rubrik UML)</td>
          <td>70%</td>
          <td><?= number_format($praktik,2) ?></td>
          <td><?= number_format($praktik * 0.70, 2) ?></td>
        </tr>
        <tr>
          <td colspan="3" class="row-total">TOTAL</td>
          <td><strong><?= $total_nilai!==null ? number_format($total_nilai,2) : '0.00' ?></strong></td>
        </tr>
      </tbody>
    </table>
    <div class="form-actions"><button onclick="window.print()">Cetak Rapor</button></div>
  </div>
<?php endif; ?>
