<?php
if (session_status() === PHP_SESSION_NONE) session_start();
$u = $_SESSION['user'] ?? null;

/* ==== Hitung path CSS dinamis ====
   - index.php berada di /public
   - assets ada di /public/assets
   Script name contoh:
     /nilai_sekolah/public/index.php  → dirname => /nilai_sekolah/public
*/
$publicDir  = rtrim(dirname($_SERVER['SCRIPT_NAME'] ?? ''), '/\\');  // /nilai_sekolah/public
$assetHref  = $publicDir . '/assets/style.css';                      // /nilai_sekolah/public/assets/style.css
?>
<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width,initial-scale=1.0">
  <title><?= isset($title) ? htmlspecialchars($title) : 'Aplikasi Nilai' ?></title>

  <!-- Gunakan path dinamis agar CSS selalu ketemu -->
  <link rel="stylesheet" href="<?= htmlspecialchars($assetHref) ?>">
</head>
<body>

<nav>
  <div class="brand">SMK TRITECH — Nilai</div>
  <?php if ($u): ?>
    <div class="menu">
      <?php if (($u['role'] ?? '') === 'admin'): ?>
        <a href="?action=admin_students">Data Siswa</a>
        <a href="?action=admin_input">Input Penilaian</a>
        <a href="?action=admin_rekap">Rekap Nilai</a>
      <?php else: ?>
        <a href="?action=student_report">Rapor Saya</a>
      <?php endif; ?>
      <a href="?action=logout">Logout</a>
    </div>
  <?php endif; ?>
</nav>

<div class="container">
