<?php $title='Input Penilaian'; ?>
<h1>Input Penilaian (Teori 30% + Praktik UML 70%)</h1>

<form method="get" action="" class="stack-md" style="max-width:760px">
  <input type="hidden" name="action" value="admin_input">
  <div class="row cols-2">
    <div>
      <label>Kelas</label>
      <select name="class_id" required>
        <option value="">-- Pilih --</option>
        <?php foreach($classes as $c):?>
        <option value="<?=$c['id']?>" <?=$sel_class==$c['id']?'selected':''?>><?=$c['name']?></option>
        <?php endforeach;?>
      </select>
    </div>
    <div>
      <label>Mapel</label>
      <select name="subject_id" required>
        <option value="">-- Pilih --</option>
        <?php foreach($subjects as $s):?>
        <option value="<?=$s['id']?>" <?=$sel_sub==$s['id']?'selected':''?>><?=$s['name']?></option>
        <?php endforeach;?>
      </select>
    </div>
  </div>
  <div>
    <label>Term/Semester</label>
    <select name="term_id" required>
      <option value="">-- Pilih --</option>
      <?php foreach($terms as $t):?>
      <option value="<?=$t['id']?>" <?=$sel_term==$t['id']?'selected':''?>><?=$t['name']?></option>
      <?php endforeach;?>
    </select>
  </div>
  <div class="form-actions"><button type="submit">Tampilkan</button></div>
</form>

<?php if($sel_class&&$sel_sub&&$sel_term):?>
  <?php if(empty($students)):?>
    <div class="alert alert-error">Belum ada siswa pada kelas ini.</div>
  <?php else:?>
  <form method="post" action="?action=admin_input_save">
    <?=function_exists('csrf_field')?csrf_field():''?>
    <input type="hidden" name="class_id" value="<?=$sel_class?>">
    <input type="hidden" name="subject_id" value="<?=$sel_sub?>">
    <input type="hidden" name="term_id" value="<?=$sel_term?>">

    <div class="card"><strong>Petunjuk:</strong> Nilai Teori 0–100. Praktik: UC (20+10+10+10+10) + AD (15+10+10+5) + Bonus max 5.</div>

    <table id="inputTable">
      <thead>
        <tr>
          <th>Nama Siswa</th>
          <th>Teori</th>
          <th>UC Aktor</th><th>UC Relasi</th><th>UC Sesuai</th><th>UC Nama</th><th>UC Rapi</th>
          <th>AD Lengkap</th><th>AD Simbol</th><th>AD Sesuai</th><th>AD Rapi</th>
          <th>Bonus</th>
        </tr>
      </thead>
      <tbody>
      <?php foreach($students as $s):?>
        <tr>
          <td><?=htmlspecialchars($s['full_name'])?></td>
          <td><input type="number" min="0" max="100" step="1" name="score[<?=$s['id']?>][theory]" value="<?=$s['theory']?>"></td>
          <td><input type="number" min="0" max="20" name="score[<?=$s['id']?>][uc_actors]" value="<?=$s['uc_actors']?>"></td>
          <td><input type="number" min="0" max="10" name="score[<?=$s['id']?>][uc_relations]" value="<?=$s['uc_relations']?>"></td>
          <td><input type="number" min="0" max="10" name="score[<?=$s['id']?>][uc_fit]" value="<?=$s['uc_fit']?>"></td>
          <td><input type="number" min="0" max="10" name="score[<?=$s['id']?>][uc_naming]" value="<?=$s['uc_naming']?>"></td>
          <td><input type="number" min="0" max="10" name="score[<?=$s['id']?>][uc_neat]" value="<?=$s['uc_neat']?>"></td>
          <td><input type="number" min="0" max="15" name="score[<?=$s['id']?>][act_complete]" value="<?=$s['act_complete']?>"></td>
          <td><input type="number" min="0" max="10" name="score[<?=$s['id']?>][act_symbols]" value="<?=$s['act_symbols']?>"></td>
          <td><input type="number" min="0" max="10" name="score[<?=$s['id']?>][act_fit]" value="<?=$s['act_fit']?>"></td>
          <td><input type="number" min="0" max="5"  name="score[<?=$s['id']?>][act_neat]" value="<?=$s['act_neat']?>"></td>
          <td><input type="number" min="0" max="5"  name="score[<?=$s['id']?>][bonus]" value="<?=$s['bonus']?>"></td>
        </tr>
      <?php endforeach;?>
      </tbody>
    </table>

    <div class="form-actions"><button type="submit">Simpan Nilai</button></div>
  </form>
  <?php endif;?>
<?php endif;?>
