<?php
class AdminRekap {
    private PDO $db;
    public function __construct(PDO $pdo){ $this->db = $pdo; }

    public function index(){
        // dropdown data
        $classes  = $this->db->query("SELECT * FROM classes ORDER BY name")->fetchAll();
        $subjects = $this->db->query("SELECT * FROM subjects ORDER BY name")->fetchAll();
        $terms    = $this->db->query("SELECT * FROM terms ORDER BY id DESC")->fetchAll();

        $sel_class = (int)($_GET['class_id'] ?? 0);
        $sel_sub   = (int)($_GET['subject_id'] ?? 0);
        $sel_term  = (int)($_GET['term_id'] ?? 0);

        $rows = [];
        if ($sel_class && $sel_sub && $sel_term){
            $sql = "
              SELECT u.id, u.full_name,
                     COALESCE(t.score,0) AS teori,
                     COALESCE(ur.uc_actors,0)+COALESCE(ur.uc_relations,0)+COALESCE(ur.uc_fit,0)+
                     COALESCE(ur.uc_naming,0)+COALESCE(ur.uc_neat,0)+
                     COALESCE(ur.act_complete,0)+COALESCE(ur.act_symbols,0)+
                     COALESCE(ur.act_fit,0)+COALESCE(ur.act_neat,0)+
                     COALESCE(ur.bonus,0) AS praktik
              FROM users u
              LEFT JOIN theory_scores t
                ON t.student_id=u.id AND t.subject_id=? AND t.term_id=?
              LEFT JOIN uml_rubric_scores ur
                ON ur.student_id=u.id AND ur.subject_id=? AND ur.term_id=?
              WHERE u.role='siswa' AND u.class_id=?
              ORDER BY u.full_name";
            $st = $this->db->prepare($sql);
            $st->execute([$sel_sub,$sel_term,$sel_sub,$sel_term,$sel_class]);
            $rows = $st->fetchAll(PDO::FETCH_ASSOC);

            // hitung final
            foreach($rows as &$r){
                $praktik = (float)$r['praktik'];
                if ($praktik > 100) $praktik = 100; // clamp
                $r['total'] = round(($r['teori']*0.30) + ($praktik*0.70), 2);
                $r['praktik'] = $praktik;
            }
            unset($r);
        }

        render_view('admin_rekap.php', compact('classes','subjects','terms','sel_class','sel_sub','sel_term','rows'));
    }
}
